/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.heroku.ui.wizard;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.IOUtil;
import com.aptana.deploy.heroku.HerokuAPI;
import com.aptana.deploy.heroku.HerokuPlugin;
import com.aptana.deploy.heroku.ui.wizard.HerokuDeployWizardPage;
import com.aptana.deploy.heroku.ui.wizard.HerokuLoginWizardPage;
import com.aptana.deploy.heroku.ui.wizard.HerokuSignupPage;
import com.aptana.deploy.heroku.ui.wizard.Messages;
import com.aptana.deploy.preferences.DeployPreferenceUtil;
import com.aptana.deploy.ui.wizard.AbstractDeployWizard;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.IGitRepositoryManager;
import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.BundleEntry;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.CommandContext;
import com.aptana.scripting.model.CommandElement;
import com.aptana.usage.UsagePlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.browser.BrowserViewer;
import org.eclipse.ui.internal.browser.WebBrowserEditor;
import org.eclipse.ui.internal.browser.WebBrowserEditorInput;
import org.osgi.service.prefs.BackingStoreException;

public class HerokuDeployWizard
extends AbstractDeployWizard {
    private static final String HEROKU_ICON = "icons/heroku_wizard.png";
    private static final String BUNDLE_HEROKU = "Heroku";

    public void addPages() {
        super.addPages();
        File credentials = HerokuAPI.getCredentialsFile();
        if (credentials.exists() && HerokuAPI.fromCredentials().authenticate().isOK()) {
            this.addPage((IWizardPage)new HerokuDeployWizardPage());
        } else {
            this.addPage((IWizardPage)new HerokuLoginWizardPage());
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setDefaultPageImageDescriptor(HerokuPlugin.getImageDescriptor(HEROKU_ICON));
    }

    public boolean performFinish() {
        WizardPage page;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        String pageName = currentPage.getName();
        IRunnableWithProgress runnable = null;
        if ("HerokuDeploy".equals(pageName)) {
            page = (HerokuDeployWizardPage)currentPage;
            runnable = this.createHerokuDeployRunnable((HerokuDeployWizardPage)page);
            DeployPreferenceUtil.setDeployType((IContainer)this.getProject(), (String)"com.aptana.deploy.heroku.provider");
            DeployPreferenceUtil.setDeployEndpoint((IContainer)this.getProject(), (String)page.getAppName());
        } else if ("HerokuSignup".equals(pageName)) {
            page = (HerokuSignupPage)currentPage;
            runnable = this.createHerokuSignupRunnable((HerokuSignupPage)page);
        }
        if (runnable != null) {
            try {
                this.getContainer().run(true, false, runnable);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)HerokuPlugin.getDefault(), (Throwable)e);
            }
        }
        return true;
    }

    protected IRunnableWithProgress createHerokuDeployRunnable(HerokuDeployWizardPage page) {
        final String appName = page.getAppName();
        final boolean publishImmediately = page.publishImmediately();
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(HerokuPlugin.getPluginIdentifier());
        prefs.putBoolean("HerokuAutoPublish", publishImmediately);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    try {
                        IGitRepositoryManager manager = GitPlugin.getDefault().getGitRepositoryManager();
                        GitRepository repo = manager.createOrAttach(HerokuDeployWizard.this.getProject(), (IProgressMonitor)sub.newChild(20));
                        repo.index().refresh((IProgressMonitor)sub.newChild(15));
                        repo.index().stageFiles((Collection)repo.index().changedFiles());
                        repo.index().commit(Messages.DeployWizard_AutomaticGitCommitMessage);
                        sub.worked(10);
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                CommandElement command = publishImmediately ? HerokuDeployWizard.this.getCommand(HerokuDeployWizard.BUNDLE_HEROKU, "Create and Deploy App") : HerokuDeployWizard.this.getCommand(HerokuDeployWizard.BUNDLE_HEROKU, "Create App");
                                if (command != null) {
                                    CommandContext context = command.createCommandContext();
                                    context.put("HEROKU_APP_NAME", (Object)appName);
                                    command.execute(context);
                                }
                            }
                        });
                    }
                    catch (CoreException ce) {
                        throw new InvocationTargetException(ce);
                    }
                }
                finally {
                    sub.done();
                }
            }
        };
        return runnable;
    }

    protected IRunnableWithProgress createHerokuSignupRunnable(HerokuSignupPage page) {
        final String userID = page.getUserID();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            private String sendPing(IProgressMonitor monitor) throws IOException {
                block5: {
                    HttpURLConnection connection = null;
                    try {
                        StringBuilder builder = new StringBuilder("http://toolbox.aptana.com");
                        builder.append("/webhook/heroku?request_id=");
                        builder.append(URLEncoder.encode(UsagePlugin.getApplicationId(), "UTF-8"));
                        builder.append("&email=");
                        builder.append(URLEncoder.encode(userID, "UTF-8"));
                        builder.append("&type=signuphook");
                        URL url = new URL(builder.toString());
                        connection = (HttpURLConnection)url.openConnection();
                        connection.setUseCaches(false);
                        connection.setAllowUserInteraction(false);
                        int responseCode = connection.getResponseCode();
                        if (responseCode != 200) {
                            IdeLog.logError((Plugin)HerokuPlugin.getDefault(), (String)MessageFormat.format(Messages.DeployWizard_FailureToGrabHerokuSignupJSError, builder.toString()));
                            break block5;
                        }
                        String string = IOUtil.read((InputStream)connection.getInputStream());
                        return string;
                    }
                    finally {
                        if (connection != null) {
                            connection.disconnect();
                        }
                    }
                }
                return "";
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    try {
                        String javascriptToInject = this.sendPing((IProgressMonitor)sub.newChild(40));
                        this.openSignup(javascriptToInject, (IProgressMonitor)sub.newChild(60));
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    sub.done();
                }
            }

            private void openSignup(final String javascript, IProgressMonitor monitor) throws Exception {
                final URL url = new URL("https://api.heroku.com/signup/aptana3");
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        HerokuDeployWizard.this.openSignupURLinEclipseBrowser(url, 14, "heroku-signup", javascript);
                    }
                });
            }
        };
        return runnable;
    }

    private CommandElement getCommand(String bundleName, String commandName) {
        BundleEntry entry = BundleManager.getInstance().getBundleEntry(bundleName);
        if (entry == null) {
            return null;
        }
        for (BundleElement bundle : entry.getContributingBundles()) {
            CommandElement command = bundle.getCommandByName(commandName);
            if (command == null) continue;
            return command;
        }
        return null;
    }

    private void openSignupURLinEclipseBrowser(URL url, int style, String browserId, final String javascript) {
        try {
            WebBrowserEditorInput input = new WebBrowserEditorInput(url, style, browserId);
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart editorPart = page.openEditor((IEditorInput)input, "org.eclipse.ui.browser.editor");
            WebBrowserEditor webBrowserEditor = (WebBrowserEditor)editorPart;
            Field f = WebBrowserEditor.class.getDeclaredField("webBrowser");
            f.setAccessible(true);
            BrowserViewer viewer = (BrowserViewer)f.get(webBrowserEditor);
            final Browser browser = viewer.getBrowser();
            browser.addProgressListener(new ProgressListener(){

                public void completed(ProgressEvent event) {
                    browser.removeProgressListener((ProgressListener)this);
                    browser.execute(javascript);
                }

                public void changed(ProgressEvent event) {
                }
            });
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)HerokuPlugin.getDefault(), (Throwable)e);
        }
    }
}

